package JavaPonies;
/*
 * This is the form to set various options and Save or Load from the Settings.ini file
 */

import javax.swing.*;


import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;

@SuppressWarnings("serial")
public class Options extends JDialog implements ActionListener {
	// Special Options
	public static boolean EnableDoubleBuffering = false;
	public static boolean EnableFullRedraw = false;
	public static boolean EnableShapeWindow = false;
	
	// Detecting the OS we are running under to enable some special options by default
	private static String os = System.getProperty("os.name").toLowerCase();
	public static boolean isUnix = os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
	public static boolean isWindows = os.indexOf("win") >= 0;
	public static boolean isMac = os.indexOf("mac") >= 0;	
	
	// Options
	public static int Pony_Speak_Chance_Counter = 5;
	public static boolean Cursor_Avoidance_Enabled = true;
	public static int Cursor_zone_counter = 100;
	public static boolean Pony_Dragging_Enabled = true;
	public static int Max_Pony_Counter = 50;
	public static int Avoidance_Size_X = 0;
	public static int Avoidance_Size_Y = 0;
	public static int Avoidance_Loc_X = 0;
	public static int Avoidance_Loc_Y = 0;
	public static boolean Sounds_Enabled = false;
	public static boolean Effects_Enabled = true;
	public static boolean Interactions_Enabled = true;
	
	// Settings.ini section constants
	private final static int SC_Options = 1;
	private final static int SC_Monitors = 2;
	private final static int SC_PonyCount = 3;
	
	// Option control references
	private JNumField txtSpeakingChance = null;
	private JCheckBox chkCursorAvoidance = null;
	private JNumField txtAvoidanceArea = null;
	private JCheckBox chkPonyDragging = null;
	private JCheckBox chkEnableSounds = null;
	private JCheckBox chkEnableEffects = null;
	private JCheckBox chkEnableInteractions = null;
	private JCheckBox chkEnableDoubleBuffer = null;
	private JCheckBox chkFullFrameRedraw = null;
	private JCheckBox chkShapeWindow = null;
	private JNumField txtMaxPonies = null;
	private JNumField txtAvoidanceSizeX = null;
	private JNumField txtAvoidanceSizeY = null;
	private JNumField txtAvoidancePointX = null;
	private JNumField txtAvoidancePointY = null;
	private JList lstMonitors = null;
	private JPreviewPanel avoidancePreview = null;
	
	// Timer for avoidance area preview
	private Timer updatePreview = new Timer(200, this);
	
	// Constructor
	public Options(JFrame owner) {
		super(owner, true); // Display as modal
		
		// Initialize the window
		initializeOptionControls();
	}

	// Constructor
	public Options(JDialog owner) {
		super(owner, true); // Display as modal
		
		// Initialize the window
		initializeOptionControls();
	}

	// Constructor
	public Options(Window owner) {
		super(owner, Dialog.ModalityType.DOCUMENT_MODAL); // Display as modal
		
		// Initialize the window
		initializeOptionControls();
	}
	
	// Initialize the window's controls and member variables
	public void initializeOptionControls() {
		// Initialize the preview update timer
		//updatePreview.setActionCommand("UpdatePreview");
		updatePreview.start();
		
		// Initialize option controls
		txtSpeakingChance = new JNumField(Integer.toString(Pony_Speak_Chance_Counter));
		txtSpeakingChance.setPreferredSize(new Dimension(60, 20));
		JLabel lblSpeakingChance = new JLabel("Pony Speaking random chance (%).");
		JLabel lblSpeakingChance2 = new JLabel("(Does not affect behaviors with speech unless 0)");
		chkCursorAvoidance = new JCheckBox("Ponies avoid cursor / stop when hovered over", Cursor_Avoidance_Enabled);
		txtAvoidanceArea = new JNumField(Integer.toString(Cursor_zone_counter));
		txtAvoidanceArea.setPreferredSize(new Dimension(60, 20));
		JLabel lblAvoidanceArea = new JLabel("Size of area around cursor to avoid.");

		chkPonyDragging = new JCheckBox("Ponies can be dragged around with the mouse", Pony_Dragging_Enabled);
		chkEnableSounds = new JCheckBox("Enable sounds", Sounds_Enabled);
		chkEnableEffects = new JCheckBox("Enable effects", Effects_Enabled);
		chkEnableInteractions = new JCheckBox("Enable interactions", Interactions_Enabled);
		chkEnableDoubleBuffer = new JCheckBox("*Double buffering", EnableDoubleBuffering);
		chkFullFrameRedraw = new JCheckBox("*Full frame redraw", EnableFullRedraw);
		chkShapeWindow = new JCheckBox("*Shaped windows", EnableShapeWindow);
		JLabel lblSpecialOptions = new JLabel("*Toggle these options if the animations behave badly");
		
		JLabel lblMonitors = new JLabel("Monitors to use:", JLabel.CENTER);
		Vector<String> allscreens = new Vector<String>();
		for (GraphicsDevice screen : WinMain.ge.getScreenDevices()) {
			allscreens.addElement(screen.getIDstring());
		}
		lstMonitors = new JList(allscreens);
		for (GraphicsDevice screen : WinMain.screens_to_use) {
			lstMonitors.setSelectedValue(screen.getIDstring(), false);
		}
		JLabel lblMonitorWarning = new JLabel("(You need at least one monitor selected)", JLabel.CENTER);
		lblMonitorWarning.setForeground(Color.RED);
		
		JLabel lblMaxPonies = new JLabel("Max # of Ponies:");
		txtMaxPonies = new JNumField(Integer.toString(Max_Pony_Counter));
		txtMaxPonies.setPreferredSize(new Dimension(60, 20));
		JLabel lblMaxPonyWarning = new JLabel("<html>**** WARNING: Too many ponies might ****<br>**** make your computer slower  ****");
		lblMaxPonyWarning.setForeground(Color.RED);
		
		JLabel lblAvoidanceZone = new JLabel("Pony avoidance zone: ");
		JLabel lblAvoidanceSize = new JLabel("Size (X,Y)", JLabel.RIGHT);
		lblAvoidanceSize.setPreferredSize(new Dimension(80, 20));
		txtAvoidanceSizeX = new JNumField(Integer.toString(Avoidance_Size_X));
		txtAvoidanceSizeX.setPreferredSize(new Dimension(60, 20));
		txtAvoidanceSizeY = new JNumField(Integer.toString(Avoidance_Size_Y));
		txtAvoidanceSizeY.setPreferredSize(new Dimension(60, 20));
		JLabel lblAvoidancePoint = new JLabel("Location (X,Y)");
		lblAvoidancePoint.setPreferredSize(new Dimension(80, 20));
		txtAvoidancePointX = new JNumField(Integer.toString(Avoidance_Loc_X));
		txtAvoidancePointX.setPreferredSize(new Dimension(60, 20));
		txtAvoidancePointY = new JNumField(Integer.toString(Avoidance_Loc_Y));
		txtAvoidancePointY.setPreferredSize(new Dimension(60, 20));
		
		avoidancePreview = new JPreviewPanel();
		avoidancePreview.previewArea.setBounds(Avoidance_Loc_X, Avoidance_Loc_Y, Avoidance_Size_X, Avoidance_Size_Y);
		
		// Whew!
		
		// Initialize command buttons
		JButton btnSave = new JButton("SAVE");
		JButton btnLoad = new JButton("LOAD");
		JButton btnReset = new JButton("RESET");
		JButton btnClose = new JButton("Close");
		
		btnSave.setActionCommand("Save");
		btnSave.addActionListener(this);
		btnLoad.setActionCommand("Load");
		btnLoad.addActionListener(this);
		btnReset.setActionCommand("Reset");
		btnReset.addActionListener(this);
		btnClose.setActionCommand("Close");
		btnClose.addActionListener(this);
		
		// Initialize the various panels that will hold the controls (boring stuff)
		JPanel speakingPanel = new JPanel();
		JPanel speakingPanelSub = new JPanel();
		((FlowLayout)speakingPanelSub.getLayout()).setVgap(0);
		JPanel mouseAvoidancePanel = new JPanel();
		JPanel mouseAvoidancePanelSub = new JPanel();
		((FlowLayout)mouseAvoidancePanelSub.getLayout()).setVgap(0);
		JPanel monitorsPanel = new JPanel(new BorderLayout());
		JPanel ponycountPanel = new JPanel();
		JPanel monitorponyPanel = new JPanel(new GridLayout(1,2));
		JPanel screenAvoidancePanel = new JPanel();
		JPanel screenXAvoidancePanel = new JPanel();
		JPanel screenYAvoidancePanel = new JPanel();
		JPanel screenavoidanceSettingsPanel = new JPanel(new GridLayout(4,1));
		JPanel screenavoidanceContainerPanel = new JPanel(new GridLayout(1,2)); 
		JPanel buttonPanel = new JPanel();
		
		// Add the controls to their respective panels
		speakingPanel.add(txtSpeakingChance);
		speakingPanel.add(lblSpeakingChance);
		speakingPanel.add(lblSpeakingChance2);
		speakingPanel.add(chkCursorAvoidance);
		speakingPanelSub.add(txtAvoidanceArea);
		speakingPanelSub.add(lblAvoidanceArea);
		speakingPanel.add(speakingPanelSub);
		
		mouseAvoidancePanel.add(chkPonyDragging);
		mouseAvoidancePanel.add(chkEnableSounds);
		mouseAvoidancePanel.add(chkEnableEffects);
		mouseAvoidancePanel.add(chkEnableInteractions);
		mouseAvoidancePanelSub.add(chkEnableDoubleBuffer);
		mouseAvoidancePanelSub.add(chkFullFrameRedraw);
		mouseAvoidancePanelSub.add(chkShapeWindow);
		mouseAvoidancePanel.add(mouseAvoidancePanelSub);
		mouseAvoidancePanel.add(lblSpecialOptions);
		
		monitorsPanel.add(lblMonitors, BorderLayout.NORTH);
		monitorsPanel.add(lstMonitors, BorderLayout.CENTER);
		monitorsPanel.add(lblMonitorWarning, BorderLayout.SOUTH);
		
		ponycountPanel.add(lblMaxPonies);
		ponycountPanel.add(txtMaxPonies);
		ponycountPanel.add(lblMaxPonyWarning);
		
		monitorponyPanel.add(monitorsPanel);
		monitorponyPanel.add(ponycountPanel);
		
		screenAvoidancePanel.add(lblAvoidanceSize);
		screenAvoidancePanel.add(lblAvoidancePoint);
		
		screenXAvoidancePanel.add(txtAvoidanceSizeX);
		screenXAvoidancePanel.add(txtAvoidancePointX);
		
		screenYAvoidancePanel.add(txtAvoidanceSizeY);
		screenYAvoidancePanel.add(txtAvoidancePointY);

		screenavoidanceSettingsPanel.add(lblAvoidanceZone);
		screenavoidanceSettingsPanel.add(screenAvoidancePanel);
		screenavoidanceSettingsPanel.add(screenXAvoidancePanel);
		screenavoidanceSettingsPanel.add(screenYAvoidancePanel);
				
		screenavoidanceContainerPanel.add(screenavoidanceSettingsPanel);
		screenavoidanceContainerPanel.add(avoidancePreview);
		
		buttonPanel.add(btnSave);
		buttonPanel.add(btnLoad);
		buttonPanel.add(btnReset);
		buttonPanel.add(btnClose);

		// Add the panels to the window
		this.setLayout(new BorderLayout());
		JPanel centerscreen = new JPanel(new GridLayout(4, 1));
		centerscreen.add(speakingPanel);
		centerscreen.add(mouseAvoidancePanel);
		centerscreen.add(monitorponyPanel);
		centerscreen.add(screenavoidanceContainerPanel);
		this.add(centerscreen, BorderLayout.CENTER);
		this.add(buttonPanel, BorderLayout.SOUTH);
		
		// Display the window
		this.setSize(507, 517);
		this.setResizable(false);
		this.setTitle("Options");
		this.setLocationRelativeTo(null);
		this.setVisible(true);		
	}

	// actionPerformed handler (buttons and timer)
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == updatePreview) {
			updatePreview();
		} else if (e.getActionCommand() == "Save") {
			updateOptions();
			saveOptions();
			JOptionPane.showMessageDialog(this, "Save completed!");
		} else if (e.getActionCommand() == "Load") {
			loadOptions();
			refreshOptions();			
		} else if (e.getActionCommand() == "Reset") {
			resetOptions();
		} else if (e.getActionCommand() == "Close") {
			updateOptions();
			this.setVisible(false);
		}
	}
	
	// Update the area avoidance rectangle
	private void updatePreview() {
		int newAvoidance_Size_X = Integer.parseInt(txtAvoidanceSizeX.getText());
		int newAvoidance_Size_Y = Integer.parseInt(txtAvoidanceSizeY.getText());
		int newAvoidance_Loc_X = Integer.parseInt(txtAvoidancePointX.getText());
		int newAvoidance_Loc_Y = Integer.parseInt(txtAvoidancePointY.getText());
		
		avoidancePreview.previewArea.setBounds(newAvoidance_Loc_X, newAvoidance_Loc_Y, newAvoidance_Size_X, newAvoidance_Size_Y);
		avoidancePreview.repaint();
	}
	
	// Reset the options to their default values
	private void resetOptions() {
		txtSpeakingChance.setText(Integer.toString(5));
		chkCursorAvoidance.setSelected(true);
		txtAvoidanceArea.setText(Integer.toString(100));
		chkPonyDragging.setSelected(true);
		chkEnableSounds.setSelected(false);
		chkEnableEffects.setSelected(true);
		chkEnableInteractions.setSelected(true);
		chkEnableDoubleBuffer.setSelected(false);
		chkFullFrameRedraw.setSelected(isMac); // Enable full frame redraw on Mac by default
		chkShapeWindow.setSelected(isUnix); // Enable shaped windows on Linux/Unix by default
		txtMaxPonies.setText(Integer.toString(50));
		txtAvoidanceSizeX.setText(Integer.toString(0));
		txtAvoidanceSizeY.setText(Integer.toString(0));
		txtAvoidancePointX.setText(Integer.toString(0));
		txtAvoidancePointY.setText(Integer.toString(0));
	}
	
	// Refresh the option controls from the option variables
	private void refreshOptions() {
		txtSpeakingChance.setText(Integer.toString(Pony_Speak_Chance_Counter));
		chkCursorAvoidance.setSelected(Cursor_Avoidance_Enabled);
		txtAvoidanceArea.setText(Integer.toString(Cursor_zone_counter));
		chkPonyDragging.setSelected(Pony_Dragging_Enabled);
		chkEnableSounds.setSelected(Sounds_Enabled);
		chkEnableEffects.setSelected(Effects_Enabled);
		chkEnableInteractions.setSelected(Interactions_Enabled);
		chkEnableDoubleBuffer.setSelected(EnableDoubleBuffering);
		chkFullFrameRedraw.setSelected(EnableFullRedraw);
		chkShapeWindow.setSelected(EnableShapeWindow);
		txtMaxPonies.setText(Integer.toString(Max_Pony_Counter));
		txtAvoidanceSizeX.setText(Integer.toString(Avoidance_Size_X));
		txtAvoidanceSizeY.setText(Integer.toString(Avoidance_Size_Y));
		txtAvoidancePointX.setText(Integer.toString(Avoidance_Loc_X));
		txtAvoidancePointY.setText(Integer.toString(Avoidance_Loc_Y));
	}
	
	// Update the option variables from the option controls
	private void updateOptions() {
		Pony_Speak_Chance_Counter = Integer.parseInt(txtSpeakingChance.getText());
		Cursor_Avoidance_Enabled = chkCursorAvoidance.isSelected();
		Cursor_zone_counter = Integer.parseInt(txtAvoidanceArea.getText());
		Pony_Dragging_Enabled = chkPonyDragging.isSelected();
		Sounds_Enabled = chkEnableSounds.isSelected();
		Effects_Enabled = chkEnableEffects.isSelected();
		Interactions_Enabled = chkEnableInteractions.isSelected();
		EnableDoubleBuffering = chkEnableDoubleBuffer.isSelected();
		EnableFullRedraw = chkFullFrameRedraw.isSelected();
		EnableShapeWindow = chkShapeWindow.isSelected();
		Max_Pony_Counter = Integer.parseInt(txtMaxPonies.getText());
		Avoidance_Size_X = Integer.parseInt(txtAvoidanceSizeX.getText());
		Avoidance_Size_Y = Integer.parseInt(txtAvoidanceSizeY.getText());
		Avoidance_Loc_X = Integer.parseInt(txtAvoidancePointX.getText());
		Avoidance_Loc_Y = Integer.parseInt(txtAvoidancePointY.getText());
		
		// Update the lit of monitors we can use
		int iScreenCount = lstMonitors.getSelectedIndices().length;
		WinMain.screens_to_use = new GraphicsDevice[iScreenCount];
		int i = 0;
		for (GraphicsDevice screen : WinMain.ge.getScreenDevices()) {
			for (Object screenID : lstMonitors.getSelectedValues()) {
				if (screen.getIDstring().equals(screenID.toString())) {
					WinMain.screens_to_use[i] = screen;
					i++;
					break;
				}
			}
		}
	}

	// Save the option variables to Settings.ini file
	public static void saveOptions() {
		try {
			PrintWriter fo = new PrintWriter(new FileOutputStream("./Settings.ini"));
			
			// Basic options
			fo.println(SC_Options + "," + Cursor_zone_counter + "," + Avoidance_Loc_X + "," + Avoidance_Loc_Y + "," + Avoidance_Size_X + "," + Avoidance_Size_Y + "," + Max_Pony_Counter + "," + Pony_Dragging_Enabled + "," + Cursor_Avoidance_Enabled + "," + Pony_Speak_Chance_Counter + "," + Effects_Enabled + "," + Sounds_Enabled + "," + Interactions_Enabled + "," + EnableDoubleBuffering + "," + EnableFullRedraw + "," + EnableShapeWindow);
			
			// Selected monitors
			for (GraphicsDevice screen : WinMain.screens_to_use) {
				fo.println(SC_Monitors + ",\"" + screen.getIDstring() + "\"");
			}
			
			// Selected ponies
			int PonyNumber = 0;
			for (Component ponypanel : WinMain.currentInstance.poniesPanel.getComponents()) {
				Component controls = ((JPanel)ponypanel).getComponent(1);
				Component ponycount = ((JPanel)controls).getComponent(3);
				JTextField textbox = (JTextField)ponycount;
				
				try {
					int numbertoadd = Integer.parseInt(textbox.getText());
					fo.println(SC_PonyCount + ",\"" + WinMain.currentInstance.Selectable_Ponies.get(PonyNumber).Name + "\"," + numbertoadd);
				} catch(NumberFormatException ex) {
					System.out.println("Error saving pony : " + PonyNumber);
				}
				
				PonyNumber++;
			}
			
			fo.close();			
		} catch (Exception ex) {
			System.out.println("Could not open file for save : Settings.ini");
			System.out.println(ex.getMessage());
		}
	}
	
	// Load the option variables from Settings.ini file
	public static void loadOptions() {
		// Initialize some special fixes for Mac and Linux/Unix before loading
		EnableFullRedraw = isMac;
		EnableShapeWindow = isUnix;
		
		try {
			Scanner fi = new Scanner(new FileInputStream("./Settings.ini"));
			
			List<String> monitors = new LinkedList<String>();
			while(fi.hasNextLine()) {
				String line = fi.nextLine();
				String[] columns = line.split(",");
				
				if (columns.length > 0) {
					if (columns[0].equals(Integer.toString(SC_Options))) { // Load basic options
						for (int i = 1; i < columns.length; i++) {
							switch(i) {
								case 1:
									Cursor_zone_counter = Integer.parseInt(columns[1]);
									break;
								case 2:
									Avoidance_Loc_X = Integer.parseInt(columns[2]);
									break;
								case 3:
									Avoidance_Loc_Y = Integer.parseInt(columns[3]);
									break;
								case 4:
									Avoidance_Size_X = Integer.parseInt(columns[4]);
									break;
								case 5:
									Avoidance_Size_Y = Integer.parseInt(columns[5]);
									break;
								case 6:
									Max_Pony_Counter = Integer.parseInt(columns[6]);
									break;
								case 7:
									Pony_Dragging_Enabled = Boolean.parseBoolean(columns[7]);
									break;
								case 8:
									Cursor_Avoidance_Enabled = Boolean.parseBoolean(columns[8]);
									break;
								case 9:
									Pony_Speak_Chance_Counter = Integer.parseInt(columns[9]);
									break;
								case 10:
									Effects_Enabled = Boolean.parseBoolean(columns[10]);
									break;
								case 11:
									Sounds_Enabled = Boolean.parseBoolean(columns[11]);
									break;
								case 12:
									Interactions_Enabled = Boolean.parseBoolean(columns[12]);
									break;
								case 13:
									EnableDoubleBuffering = Boolean.parseBoolean(columns[13]);
									break;
								case 14:
									EnableFullRedraw = Boolean.parseBoolean(columns[14]);
									break;
								case 15:
									EnableShapeWindow = Boolean.parseBoolean(columns[15]);
									break;
							}
						}
					} else if (columns[0].equals(Integer.toString(SC_Monitors))) { // Load selected monitors
						monitors.add(columns[1].replace('"', ' ').trim());
					} else if (columns[0].equals(Integer.toString(SC_PonyCount))) { // Load selected ponies
						//if (!WinMain.Ponies_Have_Launched) {
							int PonyNumber = 0;
							for (Component ponypanel : WinMain.currentInstance.poniesPanel.getComponents()) {
								Component controls = ((JPanel)ponypanel).getComponent(1);
								Component ponycount = ((JPanel)controls).getComponent(3);
								JTextField textbox = (JTextField)ponycount;
								
								if (WinMain.currentInstance.Selectable_Ponies.get(PonyNumber).Name.equals(columns[1].replace('"', ' ').trim())) {
									textbox.setText(columns[2]);
									break;
								}
								
								PonyNumber++;
							}
						//}
					}
				}
			}
			
			// Update the list of monitors we can use
			int iScreenCount = monitors.size();
			WinMain.screens_to_use = new GraphicsDevice[iScreenCount];
			int i = 0;
			for (GraphicsDevice screen : WinMain.ge.getScreenDevices()) {
				for (String screenID : monitors) {
					if (screen.getIDstring().equals(screenID)) {
						WinMain.screens_to_use[i] = screen;
						i++;
						break;
					}
				}
			}
			
			fi.close();
		} catch(Exception ex) {
			// Debug output
			System.out.println("Could not open file for load : Settings.ini");
			System.out.println(ex.getMessage());
		}
	}
}
